/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef ROBO3_LEDMATRIX_H
#define ROBO3_LEDMATRIX_H

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>
#include <stdbool.h>
#include <Arduino.h>
#include "ROBO3_ModuleProtocol.h"

class ROBO3_LedMatrix : public ROBO3_ModuleProtocol
{
public:
	ROBO3_LedMatrix();
	void setpin_mio(uint8_t port);
	void showNumber(int16_t number, uint8_t brightness);
	void showString(const char *str, uint8_t column, uint8_t brightness);
	void showBitMap(uint8_t* ledBuffer, uint8_t brightness);
	void showBit(uint8_t x, uint8_t y, uint8_t fill, uint8_t brightness);
	void showWave(uint16_t value, uint8_t brightness);
	uint8_t read(uint8_t x, uint8_t y,uint8_t fill);
	void getCommand(uint8_t* cmd, uint8_t length);
	void screenClear(void);
private:
	uint8_t _port;
	uint8_t ledBufferpoint[4][16]={{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//描点
								   {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//描点
								   {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},//描点
								   {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}};//描点
};

#endif
